/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(1.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

/////////////////////////////////////////////////////////////////////////////////

#define monster sin((iGlobalTime+80.)*.2)

mat2 r(float a) {
    float se=sin(a), co=cos(a);
    return mat2(se,co,co,-se);
}


void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
	vec2 xy = uv*2.-1.;
    uv.x*=iResolution.x/iResolution.y;
    xy.x*=iResolution.x/iResolution.y;
	vec2 p=xy*.6;
    vec3 c=vec3(0.);
	float b=.2,a=3.;
    p.x=abs(p.x);
    for (int i=0; i<20; i++) {
		float l=1.25+cos(iGlobalTime*5.)*.5;
        float t=monster+sin(iGlobalTime*a)*b;
        c+=max(0.,1.-length(p))*texture2D(iChannel0,p+.4+vec2(0.,iGlobalTime*3.)*.2).xyz*l*.15;
        p.x=abs(p.x); p=p*1.3-vec2(.3,0.);
        p=p*r(t);
		a*=0.95;
		b*=1.1;
    }
    c+=abs(p.y)*.005*vec3(.7,.8,.9);
    c+=abs(p.x)*.005*vec3(.9,.7,.8);
    gl_FragColor = vec4(pow(c,vec3(1.5)),1.);
}